﻿using System;
using System.Collections.Generic;
using System.Text;
using InSimDotNet.Packets;

namespace Dizplay_Cruise.Button
{
    public class clsSequence
    {
        protected uint _id;
        /// <summary>
        /// The ID of the sequence, as it is in the database.
        /// </summary>
        public uint Id
        {
            get { return _id; }
            set { _id = value; }
        }

        protected string _customid;
        /// <summary>
        /// The custom ID of the seruqnce, specified by the user, for own recognition purposes, as it is in the database.
        /// </summary>
        public string CustomId
        {
            get { return _customid; }
            set { _customid = value; }
        }

        protected string _function;
        /// <summary>
        /// The function of the button (e.g. display_cash / display_distance / etc).
        /// </summary>
        public string Function
        {
            get { return _function; }
            set { _function = value; }
        }

        protected string _functiongroup;
        /// <summary>
        /// The function group the button belongs to (e.g. hud / chase / etc).
        /// </summary>
        public string FunctionGroup
        {
            get { return _functiongroup; }
            set { _functiongroup = value; }
        }

        protected string _name;
        /// <summary>
        /// The name of the sequence (!! HAS TO BE UNIQUE).
        /// </summary>
        public string Name
        {
            get { return _name.ToLower(); }
            set { _name = value; }
        }

        protected string _creator;
        /// <summary>
        /// The LFS Username of the creator of this button.
        /// </summary>
        public string Creator
        {
            get { return _creator; }
            set { _creator = value; }
        }

        protected string _text;
        /// <summary>
        /// The text to assign to the button. Tags allowed (e.g. ^%D_CASH^% / ^%D_DISTANCE^%).
        /// </summary>
        public string Text
        {
            get { return _text; }
            set { _text = value; }
        }

        protected ButtonPacket _button;
        /// <summary>
        /// The button packet.
        /// </summary>
        public ButtonPacket Button
        {
            get { return _button; }
            set { _button = value; }
        }

        protected bool _public;
        /// <summary>
        /// Specifies wether this sequence is public or private.
        /// </summary>
        public bool Public
        {
            get { return _public; }
            set { _public = value; }
        }
    }
}
